/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.util;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class StringManager {
    private ResourceBundle bundle;
    private static final Map<String, StringManager> managers = new HashMap<String, StringManager>();

    private StringManager(String packageName, ClassLoader loader) {
        this(packageName, Locale.getDefault(), loader);
    }

    private StringManager(String packageName, Locale loc, ClassLoader loader) {
        String bundleName = packageName + ".LocalStrings";
        try {
            this.bundle = ResourceBundle.getBundle(bundleName, loc, loader);
        }
        catch (MissingResourceException ex) {
            this.bundle = ResourceBundle.getBundle(bundleName, Locale.US, loader);
        }
    }

    private StringManager(ResourceBundle bundle) {
        this.bundle = bundle;
    }

    public String getString(String key) {
        String str;
        if (key == null) {
            String msg = "key may not have a null value";
            throw new IllegalArgumentException(msg);
        }
        try {
            str = this.bundle.getString(key);
        }
        catch (MissingResourceException mre) {
            str = null;
        }
        return str;
    }

    public String getString(String key, Object[] args2) {
        String iString;
        String value2 = this.getString(key);
        try {
            if (args2 == null) {
                args2 = new Object[1];
            }
            Object[] nonNullArgs = args2;
            for (int i = 0; i < args2.length; ++i) {
                if (args2[i] != null) continue;
                if (nonNullArgs == args2) {
                    nonNullArgs = (Object[])args2.clone();
                }
                nonNullArgs[i] = "null";
            }
            if (value2 == null) {
                value2 = key;
            }
            iString = MessageFormat.format(value2, nonNullArgs);
        }
        catch (IllegalArgumentException iae) {
            StringBuilder buf = new StringBuilder();
            buf.append(value2);
            for (int i = 0; i < args2.length; ++i) {
                buf.append(" arg[").append(i).append("]=").append(args2[i]);
            }
            iString = buf.toString();
        }
        return iString;
    }

    public String getString(String key, Object arg) {
        Object[] args2 = new Object[]{arg};
        return this.getString(key, args2);
    }

    public String getString(String key, Object arg1, Object arg2) {
        Object[] args2 = new Object[]{arg1, arg2};
        return this.getString(key, args2);
    }

    public String getString(String key, Object arg1, Object arg2, Object arg3) {
        Object[] args2 = new Object[]{arg1, arg2, arg3};
        return this.getString(key, args2);
    }

    public String getString(String key, Object arg1, Object arg2, Object arg3, Object arg4) {
        Object[] args2 = new Object[]{arg1, arg2, arg3, arg4};
        return this.getString(key, args2);
    }

    public static synchronized StringManager getManager(String packageName, ClassLoader loader) {
        StringManager mgr = managers.get(packageName);
        if (mgr == null) {
            mgr = new StringManager(packageName, loader);
            managers.put(packageName, mgr);
        }
        return mgr;
    }

    public static synchronized StringManager getManager(ResourceBundle bundle) {
        return new StringManager(bundle);
    }

    public static synchronized StringManager getManager(String packageName, Locale loc, ClassLoader loader) {
        StringManager mgr = managers.get(packageName + '_' + loc.toString());
        if (mgr == null) {
            mgr = new StringManager(packageName, loc, loader);
            managers.put(packageName + '_' + loc.toString(), mgr);
        }
        return mgr;
    }
}

